/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.util;

import com.quantumdata.sct.comm.TEInterfaceConstants;
import com.quantumdata.sct.dao.impl.StandardCapabilityDAO;
import com.quantumdata.sct.dao.impl.StandardDAO;
import com.quantumdata.sct.dao.impl.TestCapabilityDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.vo.StandardCapabilityVO;
import com.quantumdata.sct.dao.vo.StandardVO;
import com.quantumdata.sct.dao.vo.TestCapabilityVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.dao.vo.UnitVO;
import com.quantumdata.sct.gui.actorbar.ClassifiedActorBar;
import com.quantumdata.sct.gui.actorbar.NamedActorBar;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.common.SCTTextArea;
import com.quantumdata.sct.gui.wizard.IBODialog;
import com.quantumdata.std.IRemoteConnection;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;

public class SCTSelection {
    private static SCTSelection instance = new SCTSelection();
    private NamedActorBar namedActorBar;
    private ClassifiedActorBar classifiedActorBar;
    private IBODialog iboDialog;
    private String userID;
    private String deviceID;
    private String modelID;
    private String unitID;
    private String unitSerial;
    private String standardID;
    private String uutType;
    private int address_a;
    private int address_b;
    private int address_c;
    private int address_d;
    private int vendorID;
    private int logicalAddress;
    private boolean autoStep;
    private IRemoteConnection m_connection;

    public static SCTSelection instance() {
        return instance;
    }

    private SCTSelection() {
    }

    public NamedActorBar getNamedActorBar() {
        return this.namedActorBar;
    }

    public void setNamedActorBar(NamedActorBar namedActorBar) {
        this.namedActorBar = namedActorBar;
    }

    public boolean getAutoStep() {
        return this.autoStep;
    }

    public void setAutoStep(boolean bl) {
        this.autoStep = bl;
    }

    public IBODialog getIBODialog() {
        return this.iboDialog;
    }

    public void setIBODialog(IBODialog iBODialog) {
        this.iboDialog = iBODialog;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String string) {
        this.userID = string;
        if (this.namedActorBar != null) {
            this.namedActorBar.setUser(string);
        }
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceID(String string) {
        this.deviceID = string;
        if (this.namedActorBar != null) {
            this.namedActorBar.setDevice(string);
        }
        this.enableToolsBtn();
    }

    public String getUutType() {
        return this.uutType;
    }

    public void setUutType(String string) {
        if (this.uutType != string) {
            this.uutType = string;
        }
    }

    public String getModelID() {
        return this.modelID;
    }

    public void setModelID(String string) {
        this.setModelID(string, true);
    }

    public void setModelID(String string, boolean bl) {
        if (this.modelID != string) {
            this.modelID = string;
            this.unitID = null;
            if (this.namedActorBar != null) {
                this.namedActorBar.setModel(string);
                this.namedActorBar.setUnit(this.unitID);
            }
            if (bl) {
                this.enableToolsBtn();
            }
        }
    }

    public String getUnitID() {
        return this.unitID;
    }

    public String getUnitSerial() {
        return this.unitSerial;
    }

    public void setUnit(UnitVO unitVO) {
        String string;
        String string2 = unitVO.getSerialNumber();
        if (this.unitSerial != string2) {
            this.unitSerial = string2;
        }
        if (this.unitID != (string = unitVO.getId().toString())) {
            this.unitID = string;
            if (this.namedActorBar != null) {
                this.namedActorBar.setUnit(unitVO);
            }
            this.enableToolsBtn();
        }
    }

    private void enableToolsBtn() {
        if (this.classifiedActorBar == null) {
            return;
        }
        if (this.namedActorBar == null) {
            return;
        }
        if (this.modelID != null) {
            this.namedActorBar.setUnitEnabled(true);
        }
    }

    public void setUnitID(String string) {
        if (this.unitID != string) {
            this.unitID = string;
            if (this.namedActorBar != null) {
                this.namedActorBar.setUnit(string);
            }
            this.enableToolsBtn();
        }
    }

    public void setUnitSerial(String string) {
        this.unitSerial = string;
    }

    public String getStandardID() {
        return this.standardID;
    }

    public void setStandardID(String string) {
        this.standardID = string;
    }

    public void setCurrentConnection(IRemoteConnection iRemoteConnection) {
        this.m_connection = iRemoteConnection;
    }

    public IRemoteConnection getCurrentConnection() {
        return this.m_connection;
    }

    public int getAddress_a() {
        return this.address_a;
    }

    public void setAddress_a(int n) {
        this.address_a = n;
    }

    public int getAddress_b() {
        return this.address_b;
    }

    public void setAddress_b(int n) {
        this.address_b = n;
    }

    public int getAddress_c() {
        return this.address_c;
    }

    public void setAddress_c(int n) {
        this.address_c = n;
    }

    public int getAddress_d() {
        return this.address_d;
    }

    public void setAddress_d(int n) {
        this.address_d = n;
    }

    public int getVendorID() {
        return this.vendorID;
    }

    public void setVendorID(int n) {
        this.vendorID = n;
    }

    public String getDeviceName() {
        return TEInterfaceConstants.DeviceTypeNames[Integer.parseInt(this.deviceID)];
    }

    public int getLogicalAddress() {
        return this.logicalAddress;
    }

    public void setLogicalAddress(int n) {
        this.logicalAddress = n;
    }

    public int getDeviceID(int n) {
        if (n < 0 || n >= TEInterfaceConstants.DeviceTypeAssignments.length) {
            return 10;
        }
        return TEInterfaceConstants.DeviceTypeAssignments[n];
    }

    public String getDeviceName(int n) {
        if (n < 0 || n >= TEInterfaceConstants.LogicalAddressNames.length) {
            return TEInterfaceConstants.LogicalAddressNames[15];
        }
        return TEInterfaceConstants.LogicalAddressNames[n];
    }

    public void log(String string) {
        System.out.println(string);
    }

    public void logError(String string) {
        System.err.println(string);
    }

    public void setClassifiedActorBar(ClassifiedActorBar classifiedActorBar) {
        this.classifiedActorBar = classifiedActorBar;
    }

    public static JPanel getTestHeader(TestVO testVO) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        SCTSelection.instance().addHeaderInformation(jPanel, testVO);
        SCTTextArea sCTTextArea = new SCTTextArea(testVO.getComplainceSectionId() + ": " + testVO.getDescription());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(sCTTextArea, gridBagConstraints);
        jPanel.add(sCTTextArea);
        return jPanel;
    }

    public void addHeaderInformation(JPanel jPanel, TestVO testVO) {
        block3: {
            try {
                GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
                StandardDAO standardDAO = (StandardDAO)XMLDAOFactory.getStandardDAO();
                TestCapabilityDAO testCapabilityDAO = (TestCapabilityDAO)XMLDAOFactory.getTestCapabilityDAO();
                StandardCapabilityDAO standardCapabilityDAO = (StandardCapabilityDAO)XMLDAOFactory.getStandardCapabilityDAO();
                StandardVO standardVO = (StandardVO)standardDAO.read(this.standardID);
                String string = standardVO.get_version();
                String string2 = standardVO.get_name();
                SCTLabel sCTLabel = new SCTLabel(string2 + " " + string);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 10;
                gridBagLayout.setConstraints(sCTLabel, gridBagConstraints);
                jPanel.add(sCTLabel);
                TestCapabilityVO testCapabilityVO = (TestCapabilityVO)testCapabilityDAO.read(testVO.getId());
                if (testCapabilityVO == null) break block3;
                String string3 = testCapabilityVO.getPrimaryCapabilityId();
                StandardCapabilityVO standardCapabilityVO = (StandardCapabilityVO)standardCapabilityDAO.read(this.standardID);
                for (StandardCapabilityVO.StandardCapabilityElementVO standardCapabilityElementVO : standardCapabilityVO.getStandardElements()) {
                    if (!string3.equals(standardCapabilityElementVO.getCapabilityId())) continue;
                    String string4 = standardCapabilityElementVO.getLocation();
                    SCTLabel sCTLabel2 = new SCTLabel(string4);
                    GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                    gridBagConstraints2.gridwidth = 0;
                    gridBagConstraints2.anchor = 10;
                    gridBagLayout.setConstraints(sCTLabel2, gridBagConstraints2);
                    jPanel.add(sCTLabel2);
                    String string5 = standardCapabilityElementVO.getRequirement();
                    SCTTextArea sCTTextArea = new SCTTextArea(string5);
                    GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                    gridBagConstraints3.gridwidth = 0;
                    gridBagConstraints3.anchor = 10;
                    gridBagLayout.setConstraints(sCTTextArea, gridBagConstraints3);
                    jPanel.add(sCTTextArea);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void addHeaderInformation(JPanel jPanel, String string) {
        try {
            GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
            StandardDAO standardDAO = (StandardDAO)XMLDAOFactory.getStandardDAO();
            StandardCapabilityDAO standardCapabilityDAO = (StandardCapabilityDAO)XMLDAOFactory.getStandardCapabilityDAO();
            StandardVO standardVO = (StandardVO)standardDAO.read(this.standardID);
            String string2 = standardVO.get_version();
            String string3 = standardVO.get_name();
            SCTLabel sCTLabel = new SCTLabel(string3 + " " + string2);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(sCTLabel, gridBagConstraints);
            jPanel.add(sCTLabel);
            StandardCapabilityVO standardCapabilityVO = (StandardCapabilityVO)standardCapabilityDAO.read(this.standardID);
            for (StandardCapabilityVO.StandardCapabilityElementVO standardCapabilityElementVO : standardCapabilityVO.getStandardElements()) {
                if (!string.equals(standardCapabilityElementVO.getCapabilityId())) continue;
                String string4 = standardCapabilityElementVO.getLocation();
                SCTLabel sCTLabel2 = new SCTLabel(string4);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridwidth = 0;
                gridBagConstraints2.anchor = 10;
                gridBagLayout.setConstraints(sCTLabel2, gridBagConstraints2);
                jPanel.add(sCTLabel2);
                String string5 = standardCapabilityElementVO.getRequirement();
                SCTTextArea sCTTextArea = new SCTTextArea(string5);
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridwidth = 0;
                gridBagConstraints3.anchor = 10;
                gridBagLayout.setConstraints(sCTTextArea, gridBagConstraints3);
                jPanel.add(sCTTextArea);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

